import refreshTokenHelper from "../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  if(body.payScheduleId) {
    const res: any = await event.context.fetch('models/c_orderpayschedule', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      C_Order_ID: {
        id: body.orderId,
        tableName: 'C_Order'
      },
      C_PaySchedule_ID: {
        id: body.payScheduleId,
        tableName: 'C_PaySchedule'
      },
      discountAmt: body.discountAmt,
      discountDate: body.discountDate,
      dueAmt: body.dueAmt,
      dueDate: body.dueDate,
      processed: body.processed,
      isActive: body.isActive,
      tableName: 'C_OrderPaySchedule'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})